/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.Boolean;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;

public class BooleanInput
extends Panel
implements JDMInput,
ItemListener {
    protected static ResourceBundle myResources = null;
    protected Checkbox trueCheckbox;
    protected Checkbox falseCheckbox;
    protected boolean hasErrorValue;
    protected boolean ignoreValue;

    public BooleanInput() {
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.trueCheckbox = new Checkbox(BooleanInput.getNLSString("trueLabel"), checkboxGroup, true);
        this.trueCheckbox.setBackground(JmaColors.background);
        this.trueCheckbox.addItemListener(this);
        this.add(this.trueCheckbox);
        this.falseCheckbox = new Checkbox(BooleanInput.getNLSString("falseLabel"), checkboxGroup, false);
        this.falseCheckbox.setBackground(JmaColors.background);
        this.falseCheckbox.addItemListener(this);
        this.add(this.falseCheckbox);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public Object getValue() {
        return new Boolean(this.trueCheckbox.getState());
    }

    public String toString() {
        if (this.trueCheckbox.getState()) {
            return "true";
        }
        return "false";
    }

    public void setValue(Object object) {
        if (object instanceof Boolean) {
            Boolean boolean_ = (Boolean)object;
            if (boolean_.value) {
                this.trueCheckbox.setState(true);
                this.falseCheckbox.setState(false);
            } else {
                this.trueCheckbox.setState(false);
                this.falseCheckbox.setState(true);
            }
            this.hasErrorValue = false;
            this.ignoreValue = false;
            return;
        }
        if (object instanceof SpecialValue) {
            this.trueCheckbox.setState(false);
            this.falseCheckbox.setState(false);
            this.hasErrorValue = true;
            if (object instanceof NotSupported) {
                this.ignoreValue = true;
                return;
            }
            this.ignoreValue = false;
        }
    }

    public void setValue(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("true")) {
            this.trueCheckbox.setState(true);
            this.falseCheckbox.setState(false);
            this.hasErrorValue = false;
        } else if (string2.equals("false")) {
            this.trueCheckbox.setState(false);
            this.falseCheckbox.setState(true);
            this.hasErrorValue = false;
        } else {
            this.trueCheckbox.setState(false);
            this.falseCheckbox.setState(false);
            this.hasErrorValue = true;
        }
        this.ignoreValue = false;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public boolean isValidValue() {
        return !this.hasErrorValue;
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }

    protected static String getNLSString(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.BooleanInputResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }
}

